%This script generates Fig. OA.5, composed of two figures:

%Panel A: A histogram showing the frequency with which each of the two
%actions is chosen after T episodes (fixed stopping time procedure).

%Panel B: A histogram showing the frequency with which each of the two
%actions is chosen after T episodes plus 100 episodes without change (random stopping time procedure).



%%Panel A: Fixed stopping time
    
    %read the data
    last_episodes = readmatrix('Data/last_episodes_fixed.txt');
    %plot the results
    plot(1);
    [C,~,ic] = unique(last_episodes(:,1));
    percentages = accumarray(ic, 1) / length(ic) * 100;
    bar(C, percentages);
    xTickMax = round(max(last_episodes(:,1)));
    xticks(0:1:2);
    xlim([0, xTickMax+1]);
    ylim([0 max(percentages)*1.1]);  % Add 10% space above the highest bar
    ylabel('Percentage (%)')
    xlabel(sprintf('Action chosen'))
    filename = '/Figures/Fig_OA_5_a.png';
    saveas(figure(1), [pwd filename]);
    close(gcf);


%%Panel B: Random stopping time
    
    %read the data
    last_episodes = readmatrix('Data/last_episodes_random.txt');
    %plot the results
    plot(1);
    [C,~,ic] = unique(last_episodes(:,1));
    percentages = accumarray(ic, 1) / length(ic) * 100;
    bar(C, percentages);
    xTickMax = round(max(last_episodes(:,1)));
    xticks(0:1:2);
    xlim([0, xTickMax+1]);
    ylim([0 max(percentages)*1.1]);  % Add 10% space above the highest bar
    ylabel('Percentage (%)')
    xlabel(sprintf('Action chosen'))
    filename = '/Figures/Fig_OA_5_b.png';
    saveas(figure(1), [pwd filename]);
    close(gcf);
